/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.messaging.LookupService;
import de.willuhn.jameica.security.LocalRMISocketFactory;
import de.willuhn.jameica.security.SSLRMISocketFactory;
import de.willuhn.jameica.services.SSLService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;

public class RegistryService
implements Bootable {
    private Registry registry = null;
    private RMISocketFactory socketFactory = null;

    public Class[] depends() {
        return new Class[]{SSLService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        block11: {
            if (!Application.inServerMode() || !Application.getConfig().getShareServices()) {
                try {
                    RMISocketFactory.setSocketFactory(new LocalRMISocketFactory());
                }
                catch (Exception e) {
                    Logger.error((String)"unable to apply local rmi socket factory, fallback to default", (Throwable)e);
                }
                return;
            }
            try {
                if (Application.getConfig().getRmiSSL()) {
                    Logger.info((String)"activating rmi over ssl");
                    this.socketFactory = new SSLRMISocketFactory();
                    RMISocketFactory.setSocketFactory(this.socketFactory);
                } else {
                    this.socketFactory = RMISocketFactory.getDefaultSocketFactory();
                }
                Logger.info((String)"init rmi registry");
                loader.getMonitor().setStatusText("starting rmi registry");
                loader.getMonitor().addPercentComplete(5);
                int port = Application.getConfig().getRmiPort();
                Logger.info((String)("activating rmi registry, port: " + port));
                try {
                    if (Application.getConfig().getRmiSSL()) {
                        this.registry = LocateRegistry.createRegistry(port, this.socketFactory, this.socketFactory);
                        break block11;
                    }
                    this.registry = LocateRegistry.createRegistry(port);
                }
                catch (Exception e) {
                    Logger.error((String)"failed to init RMI registry, trying to use an existing one. communication is not encrypted", (Throwable)e);
                    this.registry = LocateRegistry.getRegistry(port);
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void shutdown() {
        if (this.registry != null) {
            try {
                Logger.info((String)"shutting down rmi registry");
                UnicastRemoteObject.unexportObject(this.registry, false);
            }
            catch (NoSuchObjectException e1) {
                Logger.error((String)"failed to unexport rmi registry", (Throwable)e1);
            }
            finally {
                this.registry = null;
            }
        }
    }

    public void rebind(String name, Remote remote) throws Exception {
        if (this.registry == null) {
            return;
        }
        String rmiUrl = "rmi://" + Application.getCallback().getHostname() + ":" + Application.getConfig().getRmiPort() + "/" + name;
        this.registry.rebind(name, remote);
        LookupService.register("rmi:" + name, rmiUrl);
    }

    public void unbind(String name) throws Exception {
        if (this.registry == null) {
            return;
        }
        this.registry.unbind(name);
        LookupService.unRegister("rmi:" + name);
    }

    public RMISocketFactory getSocketFactory() {
        return this.socketFactory;
    }
}

